unit enditu;

// Copyright  2001 by Ziff-Davis, Inc.
// Written by Neil J. Rubenking

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, reObjs, ActnList, ActnMan, AppEvnts, Menus, ImgList,
  ActnCtrls, ToolWin, ActnMenus, ComCtrls, ExtCtrls, StdCtrls;

type
  TEndItForm = class(TForm)
    amMain              : TActionManager;
      // File
        acRefresh       : TAction;
        acExit          : TAction;
      // Actions
        acCloseOK       : TAction;
        acKillOK        : TAction;
        acProtect       : TAction;
        acCloseItem     : TAction;
        acKillItem      : TAction;
        acCloseAll      : TAction;
        acKillAll       : TAction;
      // Tools
        acScreenSave    : TAction;
        acPower         : TAction;
      // Help
        acHelp          : TAction;
        acAbout         : TAction;
    MainMenuBar         : TActionMainMenuBar;
    ActionsToolBar      : TActionToolBar;
    pmItems             : TPopupMenu;
      popAllowClose     : TMenuItem;
      popAllowKill      : TMenuItem;
      popProtectProg    : TMenuItem;
      popCloseProg      : TMenuItem;
      popKillProg       : TMenuItem;
    ilMain              : TImageList;
    sbMain              : TStatusBar;
    aeMain              : TApplicationEvents;
    N1                  : TMenuItem;
    Label1: TLabel;
    lvMain: TListView;
    tmrTwitch: TTimer;
    acSaveSet: TAction;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure acRefreshExecute(Sender: TObject);
    procedure acExitExecute(Sender: TObject);
    procedure acCloseOKExecute(Sender: TObject);
    procedure acKillOKExecute(Sender: TObject);
    procedure acProtectExecute(Sender: TObject);
    procedure acCloseItemExecute(Sender: TObject);
    procedure acKillItemExecute(Sender: TObject);
    procedure acCloseAllExecute(Sender: TObject);
    procedure acKillAllExecute(Sender: TObject);
    procedure acScreenSaveExecute(Sender: TObject);
    procedure acPowerExecute(Sender: TObject);
    procedure acHelpExecute(Sender: TObject);
    procedure acAboutExecute(Sender: TObject);
    procedure acRefreshUpdate(Sender: TObject);
    procedure acItemsUpdate(Sender: TObject);
    procedure acAllsUpdate(Sender: TObject);
    procedure lvMainColumnClick(Sender: TObject;
      Column: TListColumn);
    procedure lvMainCompare(Sender: TObject; Item1,
      Item2: TListItem; Data: Integer; var Compare: Integer);
    procedure lvMainMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure lvMainContextPopup(Sender: TObject; MousePos: TPoint;
      var Handled: Boolean);
    procedure lvMainCustomDrawItem(Sender: TCustomListView;
      Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
    procedure aeMainHint(Sender: TObject);
    procedure sbMainDrawPanel(StatusBar: TStatusBar; Panel: TStatusPanel;
      const Rect: TRect);
    procedure sbMainMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure aeMainIdle(Sender: TObject; var Done: Boolean);
    procedure tmrTwitchTimer(Sender: TObject);
    procedure lvMainChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure acSaveSetExecute(Sender: TObject);
  private
    { Private declarations }
    ProcList   : TStringList; // list of all running programs
    Protex     : TStringList; // stored list of protected apps
    NoProtex   : TStringList; // stored list of not-protected procs
    SortCol    : Integer; // 1-based index of most recent sort-column
    ininame    : String;  // name for INI file
    logname    : String;  // name for log file
    acthint    : String;  // hint for ongoing action
    logF       : TextFile; // name of log file
    BlockSaver : Boolean; // If true, block screen saver
    BlockPower : Boolean; // If true, block power management
    Busy       : Boolean; // True while closing or terminating
    NoInitWarn : Boolean; // If false, give initial warning
    NoProcWarn : Boolean; // If false, warn on terminate process
    NoClosWarn : Boolean; // If false, warn on close all
    NoKillWarn : Boolean; // If false, warn on kill all
    DnTri      : Integer; // index of down-triangle icon
    UpTri      : Integer; // index of up-triangle icon
    Waiting    : Boolean; // true while waiting for close
    SaverWasActive : Boolean;
    procedure LoadView;
    function AppIndex(AppType : TAppType) : Integer;
    function StatIndex(TP : TProcWinObj) : Integer;
    function CloseOne(TP : TProcWinObj) : Boolean;
    function CloseExp(TP : TProcWinObj) : Boolean;
    function KillOne(TP : TProcWinObj; VAR Err : Integer) : Boolean;
    procedure CloseAll(Automatic : Boolean);
    procedure KillAll(Automatic : Boolean);
    procedure CloseByName(const S : String);
    procedure KillByName(const S : String);
    procedure LogStart(IsClose, IsAuto : Boolean);
    procedure LogLine(const S: String); overload;
    procedure LogLine(const fmt : String; A : ARRAY OF Const);
      overload;
    procedure SaveSettings;
    procedure SortMainList;
    procedure SetBusy(Value : Boolean);
    procedure SyntaxError;
    procedure ThdDone(Sender : TObject);
    procedure ThdCount(Sender : TObject);
  public
    { Public declarations }
    procedure DefaultHandler(var Message); override;
  end;

VAR
  EndItForm  : TEndItForm;
  EndItMsg   : Cardinal;
  InitAction : Integer;
  InitFName  : String;


implementation
uses formposu, endfuncu, IniFiles, AboutBox, syntaxu, commctrl,
  dontu, cloThdU;

{$R *.DFM}
const
  sec = 'Settings'; // ini file section name

procedure TEndItForm.FormCreate(Sender: TObject);

  procedure SetTheFonts;
  // Set the menu bar font to match the system menu font, and
  // set the listview font to match the sysetm icon title font
  VAR
    NCM : NONCLIENTMETRICS;
    LF  : LOGFONT;
  begin
    FillChar(NCM, SizeOf(NCM), 0);
    NCM.cbSize := SizeOf(NCM);
    SystemParametersInfo(SPI_GETNONCLIENTMETRICS, SizeOf(NCM),
      @NCM, 0);
    MainMenuBar.Font.Handle := CreateFontIndirect(NCM.lfMenuFont);
    sbMain.Font.Handle := CreateFontIndirect(NCM.lfStatusFont);
    FillChar(LF, SizeOf(LF), 0);
    SystemParametersInfo(SPI_GETICONTITLELOGFONT, SizeOf(LF),
      @LF, 0);
    lvMain.Font.Handle := CreateFontIndirect(LF);

  end;

  procedure InitVarsAfterFonts;
  // Some of these must be initialized after SetTheFonts
  begin
    UpTri                  := ilMain.Count - 1;
    DnTri                  := ilMain.Count - 2;
    WITH sbMain DO
      begin
        Canvas.Font     := Font;
        Panels[1].Width := Canvas.TextWidth('Can kill or close') + 8;
        Panels[2].Width := Canvas.TextWidth('Application') + 8;
        Height          := Canvas.TextHeight('Ay') + 6;
      end;
    Application.HelpFile   := ChangeFileExt(Application.Exename,
      '.HLP');
    popAllowClose.ImageIndex := -1;
    popAllowKill.ImageIndex  := -1;
  end;

  procedure InitVarsBeforeIni;
  // Variables that must be initialized before reading INI data
  begin
    ProcList := TStringList.Create;
    Protex   := TStringList.Create;
    NoProtex := TStringList.Create;
    ininame  := ChangeFileExt(Application.ExeName, '.INI');
    logname  := ChangeFileExt(Application.ExeName, '.LOG');
    Width    := 600;
    Height   := 400;
  end;

  procedure GetIniData;
  VAR N, W : Integer;
  begin
    WITH TIniFile.Create(ininame) DO
    try
      SortCol     := ReadInteger(sec, 'Sort column', 2);
      BlockSaver  := ReadBool   (sec, 'BlockSaver',  True);
      BlockPower  := ReadBool   (sec, 'BlockPower',  True);
      NoInitWarn  := ReadBool   (sec, 'NoInitWarn',  False);
      NoProcWarn  := ReadBool   (sec, 'NoProcWarn',  False);
      NoClosWarn  := ReadBool   (sec, 'NoClosWarn',  False);
      NoKillWarn  := ReadBool   (sec, 'NoKillWarn',  False);
      lvMain.Columns[0].Width := ReadInteger(sec, 'ColWidth0',
        Canvas.TextWidth('Status') + 36);
      lvMain.Columns[1].Width := ReadInteger(sec, 'ColWidth1',
        Canvas.TextWidth('wwwwwwww.www') + 12);
      lvMain.Columns[2].Width := ReadInteger(sec, 'ColWidth2',
        Canvas.TextWidth('Type') + 36);
      // The default width for the other two columns is simply
      // half the remaining available space, but not less than
      // 120 pixels.
      WITH lvMain DO
        W := (ClientWidth - Columns[0].Width - Columns[1].Width -
          Columns[2].Width - GetSystemMetrics(SM_CXVSCROLL)) DIV 2;
      IF W < 120 THEN W := 120;
      lvMain.Columns[3].Width := ReadInteger(sec, 'ColWidth3', W);
      lvMain.Columns[4].Width := ReadInteger(sec, 'ColWidth4', W);
      ReadSection('Protects',   Protex);
      FOR N := 0 TO Protex.Count-1 DO
        Protex.Objects[N] := Pointer(ReadInteger('Protects',
          Protex[N], 0));
      ReadSection('NoProtects', NoProtex);
    finally
      Free;
    end;
  end;

  procedure InitVarsAfterIni;
  // Variables that must be initialized after reading INI data
  begin
    acScreenSave.Checked := BlockSaver;
    IF CanBlockPower THEN
      begin
        acPower.Enabled := True;
        acPower.Checked := BlockPower;
        DoBlockPower(BlockPower);
      end
    ELSE
      begin
        acPower.Enabled := False;
        acPower.Checked := False;
      end;
    IF UseSaverActive THEN
      begin
        SaverWasActive := GetSaverActive;
        SetSaverActive(SaverWasActive AND (NOT BlockSaver));
      end
    ELSE tmrTwitch.Enabled := BlockSaver;
  end;

begin
  ilMain.Clear;
  ilMain.GetResource(rtBitmap, 'allimage', 16, [], clFuchsia);
  SetTheFonts;
  InitVarsAfterFonts;
  InitVarsBeforeIni;
  // Set defaults in case INI file doesn't have size
  GetPosFmIni(ininame, Self, True);
  GetIniData;
  InitVarsAfterIni;
end;

procedure TEndItForm.FormDestroy(Sender: TObject);
begin
  IF UseSaverActive THEN
    SetSaverActive(SaverWasActive);
  SetPosToini(ininame, Self, True);
  SaveSettings;
end;

procedure TEndItForm.FormActivate(Sender: TObject);
// We want the window to become visible right away, and THEN
// load the initial data into its listview
begin
  // First, make the window visible
  Show;
  Application.ProcessMessages;
  // Now load the information
  LoadView;
  // Handle automatic operation
  CASE InitAction OF
    0 : begin
      IF NOT NoInitWarn THEN
        WITH TDontForm.Create(Self) DO
        try
          SetData('WARNING:'#13'EndItAll is a powerful program. If '+
            'you use it without understanding its power, you can cr'+
            'ash Windows or lose data. Please read the Help section'+
            ' on Understanding EndItAll before taking any action.',
            False);
          IF ShowModal = mrAbort THEN
            NoInitWarn := True;
        finally
          Free;
        end;
      Exit;
    end;
    -1 : begin
      SyntaxError;
    end;
    1 : begin
      Caption := 'EndItAll - Automatically close all';
      CloseAll(True);
    end;
    2 : begin
      Caption := 'EndItAll - Automatically kill all';
      KillAll(True);
    end;
    3 : begin
      Caption := 'EndItAll - Automatically close ' +
        InitFName;
      CloseByName(InitFName);
    end;
    4 : begin
      Caption := 'EndItAll - Automatically kill '+
        InitFName;
      KillByName(InitFName);
    end;
  end;
  Close; // this line not reached if no command-line
end;

procedure TEndItForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  CanClose := (NOT Busy);
end;

procedure TEndItForm.acRefreshExecute(Sender: TObject);
begin
  SetBusy(True);
  LoadView;
  SetBusy(False);
end;

procedure TEndItForm.acExitExecute(Sender: TObject);
begin
  Close;
end;

procedure TEndItForm.acCloseOKExecute(Sender: TObject);
VAR
  S   : String;
  Idx : Integer;
  TP  : TProcWinObj;
begin
  IF lvMain.Selected = nil THEN Exit;
  TP := TProcWinObj(lvMain.Selected.Data);
  S := Uppercase(ExtractFileName(TP.ExeName));
  CASE TP.ProtType OF
    ptNone   : TP.ProtType := ptNoClos;
    ptNoClos : TP.ProtType := ptNone;
    ptNoKill : TP.ProtType := ptNoBoth;
    ptNoBoth : TP.ProtType := ptNoKill;
    ELSE Exit;
  end;
  acCloseOk.Checked := TP.CloseOK;
  // Record the change
  IF TP.AppType = atNonWin THEN
    begin
      Idx := NoProtex.IndexOf(S);
      IF Idx > -1 THEN NoProtex.Delete(Idx);
      IF TP.ProtType IN [ptNone, ptNoClos] THEN
        NoProtex.Add(S);
    end
  ELSE
    begin
      Idx := Protex.IndexOf(S);
      IF Idx > -1 THEN Protex.Delete(Idx);
      IF TP.ProtType <> ptNone THEN
        Protex.AddObject(S, Pointer(TP.ProtType));
    end;
  lvMain.Selected.ImageIndex := StatIndex(TP);
end;

procedure TEndItForm.acKillOKExecute(Sender: TObject);
VAR
  S   : String;
  Idx : Integer;
  TP  : TProcWinObj;
begin
  IF lvMain.Selected = nil THEN Exit;
  TP := TProcWinObj(lvMain.Selected.Data);
  S := Uppercase(ExtractFileName(TP.ExeName));
  CASE TP.ProtType OF
    ptNone   : TP.ProtType := ptNoKill;
    ptNoKill : TP.ProtType := ptNone;
    ptNoClos : TP.ProtType := ptNoBoth;
    ptNoBoth : TP.ProtType := ptNoClos;
    ELSE Exit;
  end;
  acKillOK.Checked := TP.KillOK;
  // Record the change
  IF TP.AppType = atNonWin THEN
    begin
      Idx := NoProtex.IndexOf(S);
      IF Idx > -1 THEN NoProtex.Delete(Idx);
      IF TP.ProtType IN [ptNone, ptNoClos] THEN
        NoProtex.Add(S);
    end
  ELSE
    begin
      Idx := Protex.IndexOf(S);
      IF Idx > -1 THEN Protex.Delete(Idx);
      IF TP.ProtType <> ptNone THEN
        Protex.AddObject(S, Pointer(TP.ProtType));
    end;
  lvMain.Selected.ImageIndex := StatIndex(TP);
end;

procedure TEndItForm.acProtectExecute(Sender: TObject);
VAR
  S   : String;
  Idx : Integer;
  TP  : TProcWinObj;
begin
  IF lvMain.Selected = nil THEN Exit;
  TP := TProcWinObj(lvMain.Selected.Data);
  S := Uppercase(ExtractFileName(TP.ExeName));
  CASE TP.ProtType OF
    ptNone,
    ptNoKill,
    ptNoClos,
    ptNoBoth : TP.ProtType := ptNoBoth;
    ELSE Exit;
  end;
  acKillOK.Checked  := TP.KillOK;
  acCloseOK.Checked := TP.CloseOK;
 // Record the change
  IF TP.AppType = atNonWin THEN
    begin
      Idx := NoProtex.IndexOf(S);
      IF Idx > -1 THEN NoProtex.Delete(Idx);
      IF TP.ProtType IN [ptNone, ptNoClos] THEN
        NoProtex.Add(S);
    end
  ELSE
    begin
      Idx := Protex.IndexOf(S);
      IF Idx > -1 THEN Protex.Delete(Idx);
      IF TP.ProtType <> ptNone THEN
        Protex.AddObject(S, Pointer(TP.ProtType));
    end;
  lvMain.Selected.ImageIndex := StatIndex(TP);
end;

procedure TEndItForm.acCloseItemExecute(Sender: TObject);
// Close the selected item, if possible, and indicate success or
// failure by changing the icon
// Automatic operation is signaled by a nil value for Sender
VAR
  TP : TProcWinObj;
  S  : String;
  Idx : Integer;
begin
  IF lvMain.Selected = nil THEN Exit;
  TP := TProcWinObj(lvMain.Selected.Data);
  IF NOT (TP.ProtType IN [ptNone, ptNoKill]) THEN Exit;
  CASE TP.AppType OF
    atVisWin, atHidWin : begin
      actHint := Format('Closing "%s" - click countdown at left to '+
        'cancel', [TP.Descript]);
      Application.ProcessMessages;
      IF CloseOne(TP) THEN
        begin
          TP.ProtType := ptClosed;
          RedrawSystray;
        end
      ELSE
        begin
          TP.CloseFailed := True;
          IF Sender <> nil THEN // not automatic
            IF MessageBox(Handle, PChar(Format('EndItAll could not '+
              'close the program "%s". This could be because the pr'+
              'ogram was waiting for a response from you, or becaus'+
              'e you canceled the attempt.'#13#10#13#10'If the prog'+
              'ram really did not respond to EndItAll, you can save'+
              ' time in the future by un-checking "Allow close" for'+
              ' this program.'#13#10#13#10'Would you like to do so '+
              'now?', [TP.Descript])), PChar(Application.Title),
              MB_YESNO OR MB_ICONINFORMATION) = idYes THEN
              begin
                TP.ProtType := ptNoClos;
                S := Uppercase(ExtractFileName(TP.ExeName));
                Idx := Protex.IndexOf(S);
                IF Idx > -1 THEN Protex.Delete(Idx);
                Protex.AddObject(S, Pointer(TP.ProtType));
              end;
        end;
      lvMain.Selected.ImageIndex := StatIndex(TP);
    end;
    atExplor : begin
      IF TP.ExpWindows < 1 THEN Exit;
      actHint := 'Closing Explorer windows - click countdown at lef'+
        't to cancel';
      Application.ProcessMessages;
      CloseOne(TP);
      lvMain.Selected.SubItems[3] := TP.WinTitle;
    end;
  end;
  actHint := '';
  sbMain.Panels[3].Text := '';
end;

procedure TEndItForm.acKillItemExecute(Sender: TObject);
// Kill the selected item, if possible, and indicate success or
// failure by changing the icon
// Automatic operation is signaled by a nil value for Sender
VAR
  TP  : TProcWinObj;
  err : Integer;
  Idx : Integer;
  S   : String;

  function WarnBack : Boolean;
  // Dismissible warning about terminating a process
  begin
    IF NoProcWarn THEN Result := True
    ELSE
      WITH TDontForm.Create(Self) DO
      try
        SetData(Format('%s'#13'%s'#13'You have asked to kill this b'+
          'ackground process. It is possible that doing so will mak'+
          'e your system unstable. If you encounter problems after '+
          'terminating a background process, please restore protect'+
          'ion to that process.'#13' '#13'Kill the process?',
          [TP.Exename, TP.Descript]), True);
        CASE ShowModal OF
          idYes    : Result := True;
          idAbort  : begin
            Result        := True;
            NoProcWarn := True;
          end;
          ELSE Result := False;
        END;
      finally
        Free;
      end;
  end;

begin
  IF lvMain.Selected = nil THEN Exit;
  TP := TProcWinObj(lvMain.Selected.Data);
  IF NOT (TP.AppType IN [atVisWin,atHidWin,atNonWin]) THEN Exit;
  IF NOT (TP.ProtType IN [ptNone, ptNoClos, ptNoKill]) THEN Exit;
  actHint := Format('Killing "%s"...', [TP.Descript]);
  Application.ProcessMessages;
  IF TP.AppType = atNonWin THEN
    begin
      IF NOT WarnBack THEN Exit;
      IF KillOne(TP, err) THEN
        TP.ProtType := ptKilled
      ELSE
        TP.KillFailed := True;
    end
  ELSE
    begin
      IF TP.CloseOK AND CloseOne(TP) THEN
        TP.ProtType := ptClosed
      ELSE IF TP.KillOK AND (KillOne(TP, err)) THEN
        TP.ProtType := ptKilled
      ELSE
        TP.KillFailed := True;
    end;
  lvMain.Selected.ImageIndex := StatIndex(TP);
  IF NOT TP.KillFailed THEN
    RedrawSystray
  ELSE IF Sender <> nil THEN // not automatic
    IF MessageBox(Handle, PChar(Format('EndItAll could not kill t'+
      'he process "%s".'#13#10#13#10'Would you like to protect th'+
      'is process, so EndItAll will not try to kill it in the fut'+
      'ure?', [TP.Descript])), PChar(Application.Title),
      MB_YESNO OR MB_ICONINFORMATION) = idYes THEN
      begin
        TP.ProtType := ptNoBoth;
        S := Uppercase(ExtractFileName(TP.ExeName));
        IF TP.AppType = atNonWin THEN
          begin
            Idx := NoProtex.IndexOf(S);
            IF Idx > -1 THEN NoProtex.Delete(Idx);
          end
        ELSE
          begin
            Idx := Protex.IndexOf(S);
            IF Idx > -1 THEN Protex.Delete(Idx);
            Protex.AddObject(S, Pointer(TP.ProtType));
          end;
      end;
  lvMain.Selected.ImageIndex := StatIndex(TP);
  actHint := '';
  sbMain.Panels[3].Text := '';
end;

procedure TEndItForm.acCloseAllExecute(Sender: TObject);
begin
  CloseAll(False);
end;

procedure TEndItForm.acKillAllExecute(Sender: TObject);
begin
  KillAll(False);
end;

procedure TEndItForm.acScreenSaveExecute(Sender: TObject);
begin
  BlockSaver           := NOT BlockSaver;
  acScreenSave.Checked := BlockSaver;
  IF UseSaverActive THEN
    begin
      IF BlockSaver THEN
        SetSaverActive(False)
      ELSE
        SetSaverActive(SaverWasActive);
    end
  ELSE tmrTwitch.Enabled := BlockSaver;
end;

procedure TEndItForm.acPowerExecute(Sender: TObject);
begin
  BlockPower      := NOT BlockPower;
  acPower.Checked := BlockPower;
  DoBlockPower(BlockPower);
end;

procedure TEndItForm.acHelpExecute(Sender: TObject);
begin
  Application.HelpCommand(HELP_FINDER, 0);
end;

procedure TEndItForm.acAboutExecute(Sender: TObject);
begin
  WITH TAboutForm.Create(Self) DO
  try
    ShowModal;
  finally
    Free;
  end;
end;

procedure TEndItForm.acRefreshUpdate(Sender: TObject);
begin
  acRefresh.Enabled := NOT Busy;
end;

procedure TEndItForm.acItemsUpdate(Sender: TObject);
// Update the actions that relate to the current item
  procedure DisableAll;
  begin
    acCloseOK.Enabled    := False;
    acCloseOK.Checked    := False;
    acKillOK.Enabled     := False;
    acKillOK.Checked     := False;
    acKillItem.Enabled   := False;
    acCloseItem.Enabled  := False;
    acProtect.Enabled    := False;
  end;
begin
  IF lvMain.Selected = nil THEN DisableAll
  ELSE IF Busy THEN DisableAll
  ELSE
    WITH TProcWinObj(lvMain.Selected.Data) DO
      begin
        CASE ProtType OF
          ptNoBoth : begin
            acCloseOK.Enabled   := AppType <> atNonWin;
            acKillOK.Enabled    := AppType <> atExplor;
            acKillItem.Enabled  := False;
            acCloseItem.Enabled := False;
            acProtect.Enabled   := False;
          end;
          ptNoClos : begin
            acCloseOK.Enabled   := AppType <> atNonWin;
            acKillOK.Enabled    := AppType <> atExplor;
            acKillItem.Enabled  := AppType IN
              [atVisWin,atHidWin,atNonWin];
            acCloseItem.Enabled := False;
            acProtect.Enabled   := True;
          end;
          ptNoKill : begin
            acCloseOK.Enabled   := AppType <> atNonWin;
            acKillOK.Enabled    := AppType IN [atVisWin, atHidWin];
            acKillItem.Enabled  := False;
            acCloseItem.Enabled :=
              (AppType IN [atVisWin,atHidWin]) OR
              ((AppType = atExplor) AND (ExpWindows > 0));
            acProtect.Enabled   := True;
          end;
          ptNone : begin
            acCloseOK.Enabled   := AppType <> atNonWin;
            acKillOK.Enabled    := AppType IN [atVisWin, atHidWin];
            acKillItem.Enabled  := AppType IN
              [atVisWin,atHidWin,atNonWin];
            acCloseItem.Enabled :=
              (AppType IN [atVisWin,atHidWin]) OR
              ((AppType = atExplor) AND (ExpWindows > 0));
            acProtect.Enabled   := True;
          end;
          ELSE DisableAll;
        END;
        acCloseOK.Checked := acCloseOK.Enabled AND CloseOK;
        IF acCloseOK.Checked THEN acCloseOK.ImageIndex := 13
        ELSE                      acCloseOK.ImageIndex := 15;
        acKillOK.Checked := acKillOK.Enabled AND KillOK;
        IF acKillOK.Checked THEN  acKillOK.ImageIndex := 14
        ELSE                      acKillOK.ImageIndex := 16;
      end;
end;

procedure TEndItForm.acAllsUpdate(Sender: TObject);
// Update the close/kill all actions
VAR
  N        : Integer;
  Closable : Integer;
  Killable : Integer;
begin
  IF Busy THEN
    begin
      acKillAll.Enabled  := False;
      acCloseAll.Enabled := False;
    end
  ELSE
    begin
      Closable := 0;
      Killable := 0;
      FOR N := 0 TO lvMain.Items.Count-1 DO
        WITH TProcWinObj(lvMain.Items[N].Data) DO
          CASE ProtType OF
            ptNone : begin
              Inc(Closable);
              Inc(Killable);
            end;
            ptNoClos : Inc(Killable);
            ptNoKill : Inc(Closable);
          END;
      acCloseAll.Enabled := Closable > 0;
      acKillAll.Enabled  := Killable > 0;
    end;
end;

procedure TEndItForm.lvMainColumnClick(Sender: TObject;
  Column: TListColumn);
begin
  // A second click on the same column reverses the sort
  IF Column.Index = SortCol-1 THEN
    SortCol := -SortCol
  ELSE SortCol := Column.Index + 1;
  SortMainList;
end;

procedure TEndItForm.lvMainCompare(Sender: TObject; Item1,
  Item2: TListItem; Data: Integer; var Compare: Integer);
VAR TP1, TP2 : TProcWinObj;
begin
  TP1 := TProcWinObj(Item1.Data);
  TP2 := TProcWinObj(Item2.Data);
  CASE Abs(SortCol) OF
    // sort on status
    1 : IF TP1.ProtType < TP2.ProtType THEN Compare := -1
        ELSE IF TP1.ProtType > TP2.ProtType THEN Compare := 1
        ELSE Compare := 0;
    // sort on progname, ignore case
    2 : Compare := AnsiCompareText(Item1.SubItems[0], Item2.SubItems[0]);
    // Sort on type, next on progname
    3 : IF TP1.AppType < TP2.AppType THEN Compare := -1
        ELSE IF TP1.AppType > TP2.AppType THEN Compare := 1
        ELSE Compare := 0;
    // Sort on other column, ignore case
    ELSE
      Compare := AnsiCompareText(Item1.SubItems[Abs(SortCol)-2],
        Item2.SubItems[Abs(SortCol)-2]);
  END;
  // If otherwise equal, sort on program
  IF (Abs(SortCol) <> 2) AND (Compare = 0) THEN
    Compare := AnsiCompareText(Item1.SubItems[0], Item2.SubItems[0]);
  IF SortCol <> Abs(SortCol) THEN Compare := -Compare;
end;

procedure TEndItForm.lvMainMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
VAR TLI : TListItem;
begin
  IF Busy THEN
    begin
      sbMain.Panels[1].Text := '';
      sbMain.Panels[2].Text := '';
      sbMain.Panels[3].Text := actHint
    end
  ELSE
    begin
      TLI := lvMain.GetItemAt(X,Y);
      IF (TLI = nil) OR (TLI.Data = nil) THEN
        begin
          sbMain.Panels[1].Text := '';
          sbMain.Panels[2].Text := '';
          sbMain.Panels[3].Text := '';
        end
      ELSE WITH TProcWinObj(TLI.Data) DO
        begin
          sbMain.Panels[1].Text := ProtTypeName;
          sbMain.Panels[2].Text := AppTypeName;
          sbMain.Panels[3].Text := ExeName;
        end;
    end;
end;

procedure TEndItForm.lvMainContextPopup(Sender: TObject;
  MousePos: TPoint; var Handled: Boolean);
// When the user right-clicks, make that item selected and focused,
// and pop up the context menu. If the right-click was on the headers
// ignore it.
VAR TLI : TListItem;
begin
  Handled := True;
  TLI := lvMain.GetItemAt(MousePos.X, MousePos.Y);
  IF TLI <> nil THEN
    begin
      // If it's actually in the column headers, get out
      IF MousePos.Y < TLI.DisplayRect(drBounds).Top THEN
        Exit;
      lvMain.Selected    := TLI;
      lvMain.ItemFocused := TLI;
      WITH lvMain.ClientToScreen(MousePos) DO
        pmItems.Popup(X, Y);
    end;
end;

procedure TEndItForm.lvMainCustomDrawItem(Sender: TCustomListView;
 Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
begin
  Sender.Canvas.Font.Style := TProcWinObj(Item.Data).ProtFont;
  DefaultDraw              := True;
end;

procedure TEndItForm.aeMainHint(Sender: TObject);
begin
  sbMain.Panels[1].Text := '';
  sbMain.Panels[2].Text := '';
  IF Busy THEN
    sbMain.Panels[3].Text := actHint
  ELSE
    sbMain.Panels[3].Text := Application.Hint;
end;

procedure TEndItForm.aeMainIdle(Sender: TObject; var Done: Boolean);
VAR
  N : Integer;
  LVC : LV_COLUMN;
begin
  FOR N := 0 TO lvMain.Columns.Count-1 DO
    begin
      IF lvMain.Columns[N].ImageIndex < 0 THEN Continue;
      FillChar(LVC, SizeOf(LVC), 0);
      LVC.mask := LVCF_FMT;
      lvMain.Perform(LVM_GETCOLUMN, N, Integer(@LVC));
      IF LVC.fmt AND LVCFMT_BITMAP_ON_RIGHT = 0 THEN
        begin
          LVC.fmt := LVC.fmt OR LVCFMT_BITMAP_ON_RIGHT;
          lvMain.Perform(LVM_SETCOLUMN, N, Integer(@LVC));
        end;
    end;
end;

procedure TEndItForm.sbMainDrawPanel(StatusBar: TStatusBar;
  Panel: TStatusPanel; const Rect: TRect);
// If we're counting down, draw the countdown in a button in
// the leftmost panel
VAR R : TRect;
begin
  R := Rect;
  IF Panel.Text = '' THEN
    StatusBar.Canvas.FillRect(R)
  ELSE
    begin
      DrawFrameControl(StatusBar.Canvas.Handle, R,
        DFC_BUTTON, DFCS_BUTTONPUSH OR DFCS_ADJUSTRECT);
      DrawText(StatusBar.Canvas.Handle, PChar(Panel.Text), -1,
        R, DT_CENTER OR DT_VCENTER OR DT_SINGLELINE);
    end;

end;

procedure TEndItForm.sbMainMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  IF Button <> mbLeft THEN Exit;
  PulseEvent(StopEv);
end;

procedure TEndItForm.LoadView;
VAR N, M : Integer;
begin
  ActHint := 'Loading information...';
  SetBusy(True);
  Application.ProcessMessages;
  try
    lvMain.Items.Clear;
    GetProcsAndWindows(ProcList);
    FOR N := 0 TO ProcList.Count-1 DO
      WITH TProcWinObj(ProcList.Objects[N]) DO
        begin
          // If it's a process...
          IF AppType = atNonWin THEN
            begin
              // ... and it's not permanently protected...
              IF ProtType <> ptHiProt THEN
                begin
                  // ... set it to protected ...
                  ProtType := ptNoBoth;
                  // ... unless it's in the NoProtex list.
                  FOR M := 0 TO NoProtex.Count-1 DO
                    IF FileNameIs(NoProtex[M]) THEN
                      begin
                        ProtType := ptNoClos;
                        Break;
                      end;
                end;
            end
          // If it's not a process...
          ELSE
            begin
              // ... and it's not permanently protected ...
              IF ProtType <> ptHiProt THEN
                begin
                  // ... set it to unprotected ...
                  ProtType := ptNone;
                  // ... unless it's on the Protex list.
                  FOR M := 0 TO Protex.Count-1 DO
                    IF FileNameIs(Protex[M]) THEN
                      begin
                        ProtType := TProtType(Protex.Objects[M]);
                        Break;
                      end;
                  IF AppType = atExplor THEN
                    begin
                      IF ProtType IN [ptNone, ptNoKill] THEN
                        ProtType := ptNoKill
                      ELSE ProtType := ptNoBoth;
                    end;
                end;
            end;
        end;
    FOR N := 0 TO ProcList.Count-1 DO
      WITH TProcWinObj(ProcList.Objects[N]) DO
        begin
          WITH lvMain.Items.Add DO
            begin
              Data          := ProcList.Objects[N];
              ImageIndex := StatIndex(TProcWinObj(Data));
              // First column no text, just icon
              Caption       := '';
              SubItems.Add(ExtractFilename(Exename));
              // Third column no text, just icon
              SubItems.Add('');
              SubItemImages[1] := AppIndex(AppType);
              SubItems.Add(Descript);
              SubItems.Add(WinTitle);
            end;
          end;
    SortMainList;
  finally
    ActHint := '';
    sbMain.Panels[3].Text := '';
    SetBusy(False);
  end;
end;

function TEndItForm.AppIndex(AppType: TAppType): Integer;
// Return the proper index into the imagelist for the specified
// application type
begin
  CASE AppType OF
    atVisWin : Result := 17;
    atHidWin : Result := 18;
    atExplor : Result := 19;
    atNonWin : Result := 20;
    ELSE       Result := -1;
  END;
end;

function TEndItForm.StatIndex(TP : TProcWinObj): Integer;
// Return the proper index into the imagelist for the specified
// item's status
begin
  IF TP.CloseFailed THEN
    Result := 23
  ELSE IF TP.KillFailed THEN
    Result := 24
  ELSE
    CASE TP.ProtType OF
      ptNoClos   : Result := 14;
      ptNoKill   : Result := 13;
      ptNoBoth   : Result := 01;
      ptHiProt   : Result := 21;
      ptClosed   : Result := 22;
      ptKilled   : Result := 02;
      ELSE         Result := -1;
    END;
end;

function TEndItForm.CloseOne(TP: TProcWinObj): Boolean;
VAR
  N   : Integer;
  H   : HWnd;
  Any : Boolean;
begin
  IF TP.FilenameIs('EXPLORER.EXE') OR
     TP.FileNameIs('IEXPLORE.EXE') THEN
    begin
      Result := CloseExp(TP);
      Exit;
    end;
  SetBusy(True);
  SetLastError(0);
  TP.CloseFailed := False;
  TP.KillFailed := False;
  try
    // Close every window
    FOR N := 0 TO High(TP.Winds) DO
      begin
        H := TP.Winds[N];
        IF NOT IsWindow(H) THEN Continue;
        Waiting := True;
        TCloThread.Create(H, TP.ProcID, 30, thdDone, thdCount, False);
        WHILE Waiting DO
          Application.ProcessMessages;
        Sleep(100);
        IF IsWindow(H) THEN Break;
      end;
    Application.ProcessMessages;
    // Check if any windows remain
    Any := False;
    FOR N := 0 TO High(TP.Winds) DO
      begin
        H := TP.Winds[N];
        IF IsWindow(H) THEN Any := True;
      end;
    Result := NOT Any;
  finally
    SetBusy(False);
  end;
end;

function TEndItForm.CloseExp(TP: TProcWinObj): Boolean;
// Special handling to close visible Explorer windows
VAR
  N        : Integer;
  H        : HWnd;
  Wins     : Integer;
  Done     : Integer;
begin
  SetBusy(True);
  Wins := 0;
  Done := 0;
  TP.CloseFailed := False;
  TP.KillFailed := False;
  try
    FOR N := 0 TO High(TP.Winds) DO
      begin
        H := TP.Winds[N];
        IF NOT IsWindow(H) THEN Continue;
        IF (NOT IsExplorerWindow(H)) THEN Continue;
        Inc(Wins);
        Waiting := True;
        TCloThread.Create(H, TP.ProcID, 30, thdDone, thdCount, True);
        WHILE Waiting DO
          Application.ProcessMessages;
        Sleep(100);
        IF NOT IsWindow(H) THEN Inc(Done);
      end;
    Application.ProcessMessages;
    Result := Wins = Done;
  finally
    SetBusy(False);
  end;
end;

function TEndItForm.KillOne(TP: TProcWinObj; VAR Err : Integer): Boolean;
begin
  SetBusy(True);
  try
    TP.CloseFailed := False;
    TP.KillFailed  := False;
    Err            := Exterminate(TP.ProcID);
    Result         := Err = exterm_OK;
  finally
    SetBusy(False);
  end;
end;

procedure TEndItForm.CloseAll(Automatic : Boolean);
VAR
  Total  : Integer;
  Closed : Integer;
  N      : Integer;
  TP     : TProcWinObj;

  function WarnClose : Boolean;
  begin
    IF NoClosWarn THEN Result := True
    ELSE
      WITH TDontForm.Create(Self) DO
      try
        SetData('Action requested: Close all'#13'This action is unl'+
          'ikely to cause any problems for Windows'#13'EndItAll wil'+
          'l close all applications for which Close is allowed. Som'+
          'e applications may ask whether to save changed data befo'+
          're closing. You must answer this query within 30 seconds'+
          ', or EndItAll will not close the application.'#13' '+
          #13'Proceed?', True);
        CASE ShowModal OF
          idYes    : Result := True;
          idAbort  : begin
            Result        := True;
            NoClosWarn := True;
          end;
          ELSE Result := False;
        END;
      finally
        Free;
      end;
  end;

begin
  IF (NOT Automatic) AND (NOT WarnClose) THEN Exit;
  LogStart(True, Automatic);
  InitAction := 0;
  Total      := 0;
  Closed     := 0;
  SetBusy(True);
  try
    FOR N := 0 TO lvMain.Items.Count-1 DO
      begin
        TP := TProcWinObj(lvMain.Items[N].Data);
        IF NOT TP.CloseOK THEN Continue;
        CASE TP.AppType OF
          atVisWin,
          atHidWin : begin
            Inc(Total);
            LogLine('Attempting to close "%s"', [TP.Descript]);
            sbMain.Panels[3].Text := Format('Closing "%s" - click c'+
              'ountdown at left to cancel', [TP.Descript]);
            Application.ProcessMessages;
            IF CloseOne(TP) THEN
              begin
                LogLine(#9'Close operation succeeded');
                TP.ProtType := ptClosed;
                lvMain.Items[N].ImageIndex := StatIndex(TP);
                Inc(Closed);
              end
            ELSE
              begin
                LogLine(#9'Close operation failed');
                TP.CloseFailed := True;
                lvMain.Items[N].ImageIndex := StatIndex(TP);
              end;
          end;
          atExplor : begin
            IF TP.ExpWindows < 1 THEN Continue;
            Inc(Total);
            LogLine('Closing Explorer windows');
            sbMain.Panels[3].Text := 'Closing Explorer windows - cl'+
              'ick countdown at left to cancel';
            Application.ProcessMessages;
            IF CloseExp(TP) THEN
              begin
                LogLine(#9'Close operation succeeded');
                Inc(Closed);
              end
            ELSE
              LogLine(#9'Close operation failed');
            lvMain.Items[N].SubItems[3] := TP.WinTitle;
          end;
        END;
      end;
  finally
    sbMain.Panels[3].Text := '';
    SetBusy(False);
    LogLine(StringOfChar('-', 40));
    LogLine('Closed:'#9'%d', [Closed]);
    LogLine('Failed:'#9'%d', [Total - Closed]);
    IF NOT Automatic THEN
      MessageBox(Handle, PChar(Format('Out of %d programs for which'+
        ' the Close action is allowed, EndItAll successfully closed'+
        ' %d.', [Total, Closed])), PChar(Application.Title),
        MB_OK OR MB_ICONINFORMATION);
  end;
end;

procedure TEndItForm.KillAll(Automatic : Boolean);
VAR
  Total  : Integer;
  Closed : Integer;
  Killed : Integer;
  N      : Integer;
  Err    : Integer;
  TP     : TProcWinObj;

  function WarnKill : Boolean;
  begin
    IF NoKillWarn THEN Result := True
    ELSE
      WITH TDontForm.Create(Self) DO
      try
        SetData('Action requested: Kill all'#13'This action may cau'+
          'se Windows to crash or become unstable'#13'EndItAll will'+
          ' close all applications for which Close is allowed. It w'+
          'ill kill all background processes for which Kill is allo'+
          'wed. It will kill applications that failed to close, if '+
          'Kill is allowed. Some applications may ask whether to sa'+
          've changed data before closing. If Kill is allowed, you '+
          'must answer this query within 30 seconds, or EndItAll wi'+
          'll kill the application.'#13' '#13'Proceed?', True);
        CASE ShowModal OF
          idYes    : Result := True;
          idAbort  : begin
            Result        := True;
            NoKillWarn := True;
          end;
          ELSE Result := False;
        END;
      finally
        Free;
      end;
  end;

begin
  IF (NOT Automatic) AND (NOT WarnKill) THEN Exit;
  LogStart(False, Automatic);
  InitAction := 0;
  Total      := 0;
  Closed     := 0;
  Killed     := 0;
  SetBusy(True);
  try
    FOR N := 0 TO lvMain.Items.Count-1 DO
      begin
        TP := TProcWinObj(lvMain.Items[N].Data);
        CASE TP.AppType OF
          atVisWin,
          atHidWin : begin
            IF NOT (TP.KillOK OR TP.CloseOK) THEN
              Continue;
            Inc(Total);
            IF TP.CloseOK THEN
              begin
                LogLine('Attempting to close "%s"', [TP.Descript]);
                sbMain.Panels[3].Text := Format('Closing "%s" - click c'+
                  'ountdown at left to cancel', [TP.Descript]);
                Application.ProcessMessages;
                IF CloseOne(TP) THEN
                  begin
                    LogLine(#9'Close operation succeeded');
                    TP.ProtType := ptClosed;
                    Inc(Closed);
                  end
                ELSE
                  LogLine(#9'Close operation failed');
              end;
            IF (TP.ProtType <> ptClosed) AND TP.KillOK THEN
              begin
                LogLine('Attempting to kill "%s"', [TP.Descript]);
                sbMain.Panels[3].Text := Format('Killing "%s" ...',
                  [TP.Descript]);
                Application.ProcessMessages;
                IF KillOne(TP, Err) THEN
                  begin
                    LogLine(#9'Kill operation succeeded');
                    TP.ProtType := ptKilled;
                    Inc(Killed);
                  end
                ELSE
                  begin
                    LogLine(#9'Kill operation failed');
                    TP.KillFailed := True;
                  end;
              end;
          end;
(*
          atVisWin,
          atHidWin : begin
            Inc(Total);
            LogLine('Attempting to close "%s"', [TP.Descript]);
            sbMain.Panels[3].Text := Format('Closing "%s" - click c'+
              'ountdown at left to cancel', [TP.Descript]);
            Application.ProcessMessages;
            IF (TP.ProtType <> ptNoClos) AND CloseOne(TP) THEN
              begin
                LogLine(#9'Close operation succeeded');
                TP.ProtType := ptClosed;
                Inc(Closed);
              end
            ELSE
              begin
                LogLine(#9'Close operation failed');
                LogLine('Attempting to kill "%s"', [TP.Descript]);
                sbMain.Panels[3].Text := Format('Killing "%s" ...',
                  [TP.Descript]);
                Application.ProcessMessages;
                IF KillOne(TP, Err) THEN
                  begin
                    LogLine(#9'Kill operation succeeded');
                    TP.ProtType := ptKilled;
                    Inc(Killed);
                  end
                ELSE
                  begin
                    LogLine(#9'Kill operation failed');
                    TP.KillFailed := True;
                  end;
              end;
          end;
*)
          atNonWin : begin
            IF NOT TP.KillOK THEN Continue;
            Inc(Total);
            LogLine('Attempting to kill "%s"', [TP.Descript]);
            sbMain.Panels[3].Text := Format('Killing "%s" ...',
              [TP.Descript]);
            Application.ProcessMessages;
            IF KillOne(TP, Err) THEN
              begin
                LogLine(#9'Kill operation succeeded');
                TP.ProtType := ptKilled;
                Inc(Killed);
              end
            ELSE
              begin
                LogLine(#9'Kill operation failed');
                TP.KillFailed := True;
              end;
          end;
          atExplor : begin
            IF NOT TP.CloseOK THEN Continue;
            IF TP.ExpWindows < 1 THEN Continue;
            Inc(Total);
            LogLine('Closing Explorer windows');
            sbMain.Panels[3].Text := 'Closing Explorer windows - cl'+
              'ick countdown at left to cancel';
            Application.ProcessMessages;
            CloseExp(TP);
            IF CloseExp(TP) THEN
              begin
                LogLine(#9'Close operation succeeded');
                Inc(Closed);
              end
            ELSE
              LogLine(#9'Close operation failed');
            lvMain.Items[N].SubItems[3] := TP.WinTitle;
          end;
        END;
       lvMain.Items[N].ImageIndex := StatIndex(TP);
      end;
  finally
    RedrawSystray;
    sbMain.Panels[3].Text := '';
    LogLine(StringOfChar('-', 40));
    LogLine('Closed:'#9'%d', [Closed]);
    LogLine('Killed:'#9'%d', [Killed]);
    LogLine('Failed:'#9'%d', [Total - Closed - Killed]);
    SetBusy(False);
    IF NOT Automatic THEN
      MessageBox(Handle, PChar(Format('Out of %d programs for which'+
        ' the Close or Kill action is allowed, EndItAll closed %d a'+
        'nd killed %d.', [Total, Closed, Killed])),
        PChar(Application.Title), MB_OK OR MB_ICONINFORMATION);
  end;
end;

procedure TEndItForm.CloseByName(const S: String);
VAR N : Integer;
begin
  FOR N := 0 TO lvMain.Items.Count-1 DO
    WITH TProcWinObj(lvMain.Items[N].Data) DO
      IF CloseOK AND FileNameIs(S) THEN
        begin
          lvMain.Selected    := lvMain.Items[N];
          lvMain.ItemFocused := lvMain.Selected;
          acCloseItemExecute(nil)
        end;
end;

procedure TEndItForm.KillByName(const S: String);
VAR N : Integer;
begin
  FOR N := 0 TO lvMain.Items.Count-1 DO
    WITH TProcWinObj(lvMain.Items[N].Data) DO
      begin
        IF (KillOK OR CloseOK) AND FileNameIs(S) THEN
          begin
            lvMain.Selected    := lvMain.Items[N];
            lvMain.ItemFocused := lvMain.Selected;
            acKillItemExecute(nil)
          end;
      end;
end;

procedure TEndItForm.LogStart(IsClose, IsAuto: Boolean);
// Start the log file for a close/kill all operation
begin
  AssignFile(LogF, logname);
  IF FileExists(logname) THEN
    Append(LogF)
  ELSE
    Rewrite(LogF);
  WriteLn(LogF, StringOfChar('*', 40));
  Write(LogF, 'EndItAll log: ');
  WriteLn(LogF, FormatDateTime('mmmm d, yyyy "at" t', Now));
  IF IsClose THEN
    Write(LogF, 'Action: Close all')
  ELSE
    Write(LogF, 'Action: Kill all');
  IF IsAuto THEN
    WriteLn(LogF, ' (automatic)')
  ELSE
    WriteLn(LogF, ' (manual)');
  WriteLn(LogF, StringOfChar('-', 40));
  CloseFile(LogF);
end;

procedure TEndItForm.LogLine(const S: String);
begin
  Append(LogF);
  WriteLn(LogF, S);
  CloseFile(LogF);
end;

procedure TEndItForm.LogLine(const fmt: String; A: array of Const);
begin
  LogLine(Format(fmt, A));
end;

procedure TEndItForm.SaveSettings;
VAR N : Integer;
begin
  WITH TIniFile.Create(ininame) DO
  try
    WriteInteger(sec, 'Sort column', SortCol);
    WriteBool   (sec, 'BlockSaver',  BlockSaver);
    WriteBool   (sec, 'BlockPower',  BlockPower);
    WriteBool   (sec, 'NoInitWarn',  NoInitWarn);
    WriteBool   (sec, 'NoProcWarn',  NoProcWarn);
    WriteBool   (sec, 'NoClosWarn',  NoClosWarn);
    WriteBool   (sec, 'NoKillWarn',  NoKillWarn);
    FOR N := 0 TO lvMain.Columns.Count-1 DO
      WriteInteger(sec, 'ColWidth'+IntToStr(N),
        lvMain.Columns[N].Width);
    EraseSection('Protects');
    FOR N := 0 TO Protex.Count-1 DO
      WriteInteger('Protects', Protex[N],
        Integer(Protex.Objects[N]));
    EraseSection('NoProtects');
    FOR N := 0 TO NoProtex.Count-1 DO
      WriteInteger('NoProtects', NoProtex[N], 1);
  finally
    Free;
  end;
end;

procedure TEndItForm.SortMainList;
VAR N : Integer;
begin
  IF SortCol = 0 THEN SortCol := 1;
  IF Abs(SortCol) > lvMain.Columns.Count THEN SortCol := 1;
  WITH lvMain DO
    begin
      AlphaSort;
      FOR N := 0 TO lvMain.Columns.Count-1 DO
        IF N = SortCol-1 THEN
          lvMain.Columns[N].ImageIndex := dnTri
        ELSE IF N = (-SortCol) - 1 THEN
          lvMain.Columns[N].ImageIndex := upTri
        ELSE
          lvMain.Columns[N].ImageIndex := -1;
    end;
end;

procedure TEndItForm.SetBusy(Value: Boolean);
begin
  Busy := Value;
  IF Busy THEN
    begin
      // Set the cursor for specific part of the program,
      // leaving the status bar to have an arrow cursor
      Self.Cursor           := crHourglass;
      lvMain.Cursor         := crHourglass;
      MainMenuBar.Cursor    := crHourglass;
      ActionsToolBar.Cursor := crHourglass;
      sbMain.Panels[3].Text := actHint;
    end
  ELSE
    begin
      Self.Cursor           := crDefault;
      lvMain.Cursor         := crDefault;
      MainMenuBar.Cursor    := crDefault;
      ActionsToolBar.Cursor := crDefault;
    end;
  lvMain.Enabled := NOT Busy;
  acRefreshUpdate(acRefresh);
  acItemsUpdate  (acCloseOK);
  acAllsUpdate   (acKillAll);
end;

procedure TEndItForm.SyntaxError;
begin
  WITH TSyntaxForm.Create(Self) DO
  try
    ShowModal;
  finally
    Free;
  end;
end;

procedure TEndItForm.DefaultHandler(var Message);
// If a second instance performs some automatic action, it will tell
// this instance to refresh its view.
VAR H : THandle;
begin
  inherited;
  WITH TMessage(Message) DO
    IF Msg = EndItMsg THEN
      begin
        CASE wParam OF
          0 : SyntaxError;
          ELSE
            begin
              // Wait for the other instance to close
              H := OpenProcess(PROCESS_ALL_ACCESS, False, lParam);
              WaitForSingleObject(H, 2000);
              LoadView;
            end;
        END;
      end;
end;

procedure TEndItForm.ThdCount(Sender: TObject);
begin
  WITH Sender AS TCloThread DO
    sbMain.Panels[0].Text := IntToStr(Seconds);
end;

procedure TEndItForm.ThdDone(Sender: TObject);
begin
  Waiting := False;
  sbMain.Panels[0].Text := '';
end;

procedure TEndItForm.tmrTwitchTimer(Sender: TObject);
begin
  keybd_event(VK_SHIFT, $2A, 0, 0);
  keybd_event(VK_SHIFT, $2A, KEYEVENTF_KEYUP, 0);
end;

procedure TEndItForm.lvMainChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
  acItemsUpdate(acCloseOK);
end;

procedure TEndItForm.acSaveSetExecute(Sender: TObject);
begin
  SaveSettings;
end;

end.



